import{m as r}from"./vendor-ui-CflGdlft.js";document.addEventListener("alpine:init",()=>{r.data("orderTable",()=>({orders:[],filteredOrders:[],selectedOrders:[],currentPage:1,itemsPerPage:10,searchQuery:"",statusFilter:"",dateFilter:"",sortField:"orderNumber",sortDirection:"desc",isLoading:!1,chartsInitialized:!1,stats:{total:0,pending:0,shipped:0,revenue:0},statusStats:[],init(){this.loadSampleData(),this.filterOrders(),this.calculateStats(),setTimeout(()=>{this.initCharts()},500)},loadSampleData(){this.orders=[{id:1,orderNumber:"ORD-2025-001",customer:{name:"John Smith",email:"john@example.com",avatar:"/assets/images/avatar-placeholder.svg"},items:[{name:"iPhone 14 Pro",quantity:1,price:999.99}],itemCount:1,total:999.99,status:"pending",orderDate:"2025-01-15",shippingAddress:"123 Main St, City, State 12345"},{id:2,orderNumber:"ORD-2025-002",customer:{name:"Sarah Johnson",email:"sarah@example.com",avatar:"/assets/images/avatar-placeholder.svg"},items:[{name:"MacBook Air M2",quantity:1,price:1199.99},{name:"Wireless Mouse",quantity:1,price:49.99}],itemCount:2,total:1249.98,status:"processing",orderDate:"2025-01-14",shippingAddress:"456 Oak Ave, City, State 67890"},{id:3,orderNumber:"ORD-2025-003",customer:{name:"Mike Davis",email:"mike@example.com",avatar:"/assets/images/avatar-placeholder.svg"},items:[{name:"Cotton T-Shirt",quantity:3,price:24.99}],itemCount:3,total:74.97,status:"shipped",orderDate:"2025-01-13",shippingAddress:"789 Pine St, City, State 54321"},{id:4,orderNumber:"ORD-2025-004",customer:{name:"Emily Brown",email:"emily@example.com",avatar:"/assets/images/avatar-placeholder.svg"},items:[{name:"JavaScript Guide",quantity:1,price:39.99},{name:"Python Cookbook",quantity:1,price:44.99}],itemCount:2,total:84.98,status:"delivered",orderDate:"2025-01-12",shippingAddress:"321 Elm St, City, State 13579"},{id:5,orderNumber:"ORD-2025-005",customer:{name:"David Wilson",email:"david@example.com",avatar:"/assets/images/avatar-placeholder.svg"},items:[{name:"Wireless Headphones",quantity:1,price:149.99}],itemCount:1,total:149.99,status:"cancelled",orderDate:"2025-01-11",shippingAddress:"654 Maple Dr, City, State 24680"},{id:6,orderNumber:"ORD-2025-006",customer:{name:"Lisa Anderson",email:"lisa@example.com",avatar:"/assets/images/avatar-placeholder.svg"},items:[{name:"Smart Home Hub",quantity:1,price:199.99},{name:"Smart Bulbs",quantity:4,price:19.99}],itemCount:5,total:279.95,status:"processing",orderDate:"2025-01-10",shippingAddress:"987 Cedar Ln, City, State 97531"},{id:7,orderNumber:"ORD-2025-007",customer:{name:"Robert Martinez",email:"robert@example.com",avatar:"/assets/images/avatar-placeholder.svg"},items:[{name:"Samsung Galaxy S24",quantity:1,price:899.99}],itemCount:1,total:899.99,status:"pending",orderDate:"2025-01-09",shippingAddress:"456 Valley Rd, City, State 11223"},{id:8,orderNumber:"ORD-2025-008",customer:{name:"Jennifer Taylor",email:"jennifer@example.com",avatar:"/assets/images/avatar-placeholder.svg"},items:[{name:"Yoga Mat Premium",quantity:2,price:49.99},{name:"Winter Jacket",quantity:1,price:189.99}],itemCount:3,total:289.97,status:"shipped",orderDate:"2025-01-08",shippingAddress:"789 Mountain View Dr, City, State 44556"},{id:9,orderNumber:"ORD-2025-009",customer:{name:"Christopher Lee",email:"chris@example.com",avatar:"/assets/images/avatar-placeholder.svg"},items:[{name:"React Handbook",quantity:1,price:54.99},{name:"Node.js Complete Guide",quantity:1,price:59.99},{name:"Docker Deep Dive",quantity:1,price:49.99}],itemCount:3,total:164.97,status:"delivered",orderDate:"2025-01-07",shippingAddress:"123 Tech Street, City, State 77889"},{id:10,orderNumber:"ORD-2025-010",customer:{name:"Amanda Clark",email:"amanda@example.com",avatar:"/assets/images/avatar-placeholder.svg"},items:[{name:"Gaming Mouse RGB",quantity:1,price:79.99},{name:"Mechanical Keyboard",quantity:1,price:159.99}],itemCount:2,total:239.98,status:"processing",orderDate:"2025-01-06",shippingAddress:"321 Gaming Ave, City, State 99001"},{id:11,orderNumber:"ORD-2025-011",customer:{name:"Daniel Rodriguez",email:"daniel@example.com",avatar:"/assets/images/avatar-placeholder.svg"},items:[{name:"Coffee Maker Deluxe",quantity:1,price:249.99}],itemCount:1,total:249.99,status:"pending",orderDate:"2025-01-05",shippingAddress:"654 Coffee St, City, State 33445"},{id:12,orderNumber:"ORD-2025-012",customer:{name:"Michelle White",email:"michelle@example.com",avatar:"/assets/images/avatar-placeholder.svg"},items:[{name:"Running Shoes",quantity:1,price:129.99},{name:"Casual Polo Shirt",quantity:2,price:39.99}],itemCount:3,total:209.97,status:"shipped",orderDate:"2025-01-04",shippingAddress:"987 Sports Blvd, City, State 55667"},{id:13,orderNumber:"ORD-2025-013",customer:{name:"Kevin Thompson",email:"kevin@example.com",avatar:"/assets/images/avatar-placeholder.svg"},items:[{name:'Tablet Pro 12.9"',quantity:1,price:1099.99}],itemCount:1,total:1099.99,status:"delivered",orderDate:"2025-01-03",shippingAddress:"147 Tech Plaza, City, State 88990"},{id:14,orderNumber:"ORD-2025-014",customer:{name:"Rachel Garcia",email:"rachel@example.com",avatar:"/assets/images/avatar-placeholder.svg"},items:[{name:"Garden Planter Set",quantity:1,price:89.99},{name:"Desk Organizer",quantity:2,price:34.99}],itemCount:3,total:159.97,status:"processing",orderDate:"2025-01-02",shippingAddress:"258 Garden Way, City, State 22334"},{id:15,orderNumber:"ORD-2025-015",customer:{name:"Steven Hall",email:"steven@example.com",avatar:"/assets/images/avatar-placeholder.svg"},items:[{name:"AI & Machine Learning",quantity:1,price:79.99}],itemCount:1,total:79.99,status:"pending",orderDate:"2025-01-01",shippingAddress:"369 Learning Lane, City, State 66778"},{id:16,orderNumber:"ORD-2024-050",customer:{name:"Nicole Allen",email:"nicole@example.com",avatar:"/assets/images/avatar-placeholder.svg"},items:[{name:"Wireless Headphones",quantity:2,price:149.99}],itemCount:2,total:299.98,status:"delivered",orderDate:"2024-12-30",shippingAddress:"741 Audio Street, City, State 99887"},{id:17,orderNumber:"ORD-2024-049",customer:{name:"Anthony Young",email:"anthony@example.com",avatar:"/assets/images/avatar-placeholder.svg"},items:[{name:"Cotton T-Shirt",quantity:5,price:24.99}],itemCount:5,total:124.95,status:"shipped",orderDate:"2024-12-29",shippingAddress:"852 Fashion Ave, City, State 11229"},{id:18,orderNumber:"ORD-2024-048",customer:{name:"Patricia King",email:"patricia@example.com",avatar:"/assets/images/avatar-placeholder.svg"},items:[{name:"Kitchen Knife Set",quantity:1,price:129.99},{name:"Coffee Maker Deluxe",quantity:1,price:249.99}],itemCount:2,total:379.98,status:"processing",orderDate:"2024-12-28",shippingAddress:"963 Kitchen Rd, City, State 44556"},{id:19,orderNumber:"ORD-2024-047",customer:{name:"Joshua Wright",email:"joshua@example.com",avatar:"/assets/images/avatar-placeholder.svg"},items:[{name:"Smart Home Hub",quantity:1,price:199.99},{name:"Gaming Mouse RGB",quantity:1,price:79.99}],itemCount:2,total:279.98,status:"cancelled",orderDate:"2024-12-27",shippingAddress:"147 Smart Home Dr, City, State 77889"},{id:20,orderNumber:"ORD-2024-046",customer:{name:"Laura Lopez",email:"laura@example.com",avatar:"/assets/images/avatar-placeholder.svg"},items:[{name:"MacBook Air M2",quantity:1,price:1199.99}],itemCount:1,total:1199.99,status:"delivered",orderDate:"2024-12-26",shippingAddress:"456 Tech Center, City, State 33221"}]},calculateStats(){this.stats.total=this.orders.length,this.stats.pending=this.orders.filter(t=>t.status==="pending").length,this.stats.shipped=this.orders.filter(t=>t.status==="shipped").length,this.stats.revenue=this.orders.filter(t=>t.status!=="cancelled").reduce((t,a)=>t+a.total,0);const e={};this.orders.forEach(t=>{e[t.status]=(e[t.status]||0)+1}),this.statusStats=Object.entries(e).map(([t,a])=>({name:t.charAt(0).toUpperCase()+t.slice(1),count:a,percentage:Math.round(a/this.orders.length*100),color:this.getStatusColor(t)}))},getStatusColor(e){return{pending:"#ffc107",processing:"#0d6efd",shipped:"#17a2b8",delivered:"#28a745",cancelled:"#dc3545"}[e]||"#6c757d"},filterOrders(){this.filteredOrders=this.orders.filter(e=>{const t=!this.searchQuery||e.orderNumber.toLowerCase().includes(this.searchQuery.toLowerCase())||e.customer.name.toLowerCase().includes(this.searchQuery.toLowerCase())||e.customer.email.toLowerCase().includes(this.searchQuery.toLowerCase()),a=!this.statusFilter||e.status===this.statusFilter,s=!this.dateFilter||this.matchesDateFilter(e.orderDate);return t&&a&&s}),this.sortOrders(),this.currentPage=1},matchesDateFilter(e){const t=new Date,a=new Date(e);switch(this.dateFilter){case"today":return a.toDateString()===t.toDateString();case"week":const s=new Date(t.getTime()-10080*60*1e3);return a>=s;case"month":const i=new Date(t.getTime()-720*60*60*1e3);return a>=i;default:return!0}},sortOrders(){this.filteredOrders.sort((e,t)=>{let a=e[this.sortField],s=t[this.sortField];return this.sortField==="total"?(a=parseFloat(a),s=parseFloat(s)):this.sortField==="orderDate"?(a=new Date(a),s=new Date(s)):(a=a.toString().toLowerCase(),s=s.toString().toLowerCase()),this.sortDirection==="asc"?a<s?-1:a>s?1:0:a>s?-1:a<s?1:0})},sortBy(e){this.sortField===e?this.sortDirection=this.sortDirection==="asc"?"desc":"asc":(this.sortField=e,this.sortDirection="asc"),this.filterOrders()},toggleAll(e){e?this.selectedOrders=this.paginatedOrders.map(t=>t.id):this.selectedOrders=[]},bulkAction(e){if(this.selectedOrders.length===0)return;const t=this.orders.filter(a=>this.selectedOrders.includes(a.id));switch(e){case"processing":t.forEach(a=>{a.status==="pending"&&(a.status="processing")}),this.showNotification("Orders marked as processing!","success");break;case"shipped":t.forEach(a=>{a.status==="processing"&&(a.status="shipped")}),this.showNotification("Orders marked as shipped!","success");break;case"delivered":t.forEach(a=>{a.status==="shipped"&&(a.status="delivered")}),this.showNotification("Orders marked as delivered!","success");break}this.selectedOrders=[],this.calculateStats()},viewOrder(e){console.log("View order:",e),this.showNotification("Order details would open here","info")},trackOrder(e){console.log("Track order:",e),this.showNotification("Order tracking would open here","info")},printInvoice(e){console.log("Print invoice for order:",e),this.showNotification("Invoice would be generated and printed","info")},cancelOrder(e){confirm(`Are you sure you want to cancel order ${e.orderNumber}?`)&&(e.status="cancelled",this.calculateStats(),this.showNotification("Order cancelled successfully!","success"))},exportOrders(){const e=`data:text/csv;charset=utf-8,Order Number,Customer,Email,Items,Total,Status,Date
`+this.filteredOrders.map(s=>`"${s.orderNumber}","${s.customer.name}","${s.customer.email}","${s.itemCount}","${s.total}","${s.status}","${s.orderDate}"`).join(`
`),t=encodeURI(e),a=document.createElement("a");a.setAttribute("href",t),a.setAttribute("download","orders.csv"),document.body.appendChild(a),a.click(),document.body.removeChild(a),this.showNotification("Orders exported successfully!","success")},showNotification(e,t="info"){typeof Swal<"u"?Swal.fire({title:e,icon:t==="success"?"success":t==="error"?"error":"info",toast:!0,position:"top-end",showConfirmButton:!1,timer:3e3}):alert(e)},initCharts(){this.chartsInitialized||(this.initOrderTrendsChart(),this.initStatusChart(),this.chartsInitialized=!0)},initOrderTrendsChart(){const e=document.getElementById("orderTrendsChart");if(!e){console.warn("Order trends chart element not found");return}e.innerHTML="";try{const t={series:[{name:"Orders",data:[12,19,15,27,24,32,28]},{name:"Revenue",data:[1200,1900,1500,2700,2400,3200,2800]}],chart:{type:"area",height:300,toolbar:{show:!1}},colors:["#6366f1","#10b981"],fill:{type:"gradient",gradient:{shadeIntensity:1,opacityFrom:.7,opacityTo:.3}},stroke:{curve:"smooth",width:2},xaxis:{categories:["Mon","Tue","Wed","Thu","Fri","Sat","Sun"]},yaxis:[{title:{text:"Orders"}},{opposite:!0,title:{text:"Revenue ($)"}}],tooltip:{y:[{formatter:function(s){return s+" orders"}},{formatter:function(s){return"$"+s}}]}};new ApexCharts(e,t).render()}catch(t){console.error("Error rendering order trends chart:",t)}},initStatusChart(){const e=document.getElementById("statusChart");if(!e){console.warn("Status chart element not found");return}e.innerHTML="";try{const t={series:this.statusStats.map(s=>s.count),chart:{type:"donut",height:200},labels:this.statusStats.map(s=>s.name),colors:this.statusStats.map(s=>s.color),plotOptions:{pie:{donut:{size:"70%"}}},legend:{show:!1},tooltip:{y:{formatter:function(s){return s+" orders"}}}};new ApexCharts(e,t).render()}catch(t){console.error("Error rendering status chart:",t)}},get paginatedOrders(){const e=(this.currentPage-1)*this.itemsPerPage,t=e+this.itemsPerPage;return this.filteredOrders.slice(e,t)},get totalPages(){return Math.ceil(this.filteredOrders.length/this.itemsPerPage)},get visiblePages(){if(this.totalPages<=1)return[1];const e=[];if(e.push(1),this.totalPages<=7)for(let t=2;t<=this.totalPages;t++)e.push(t);else if(this.currentPage<=4){for(let t=2;t<=5;t++)e.push(t);e.push("..."),e.push(this.totalPages)}else if(this.currentPage>=this.totalPages-3){e.push("...");for(let t=this.totalPages-4;t<=this.totalPages;t++)e.push(t)}else{e.push("...");for(let t=this.currentPage-1;t<=this.currentPage+1;t++)e.push(t);e.push("..."),e.push(this.totalPages)}return e},goToPage(e){e>=1&&e<=this.totalPages&&(this.currentPage=e)}})),r.data("searchComponent",()=>({query:"",results:[],search(){console.log("Searching for:",this.query),this.results=[]}})),r.data("themeSwitch",()=>({currentTheme:"light",init(){this.currentTheme=localStorage.getItem("theme")||"light",document.documentElement.setAttribute("data-bs-theme",this.currentTheme)},toggle(){this.currentTheme=this.currentTheme==="light"?"dark":"light",document.documentElement.setAttribute("data-bs-theme",this.currentTheme),localStorage.setItem("theme",this.currentTheme)}}))});
