import{m as o}from"./vendor-ui-CflGdlft.js";document.addEventListener("alpine:init",()=>{o.data("productTable",()=>({products:[],filteredProducts:[],selectedProducts:[],currentPage:1,itemsPerPage:10,searchQuery:"",categoryFilter:"",stockFilter:"",sortField:"name",sortDirection:"asc",isLoading:!1,chartsInitialized:!1,stats:{total:0,inStock:0,lowStock:0,totalValue:0},categoryStats:[],init(){this.loadSampleData(),this.filterProducts(),this.calculateStats(),setTimeout(()=>{this.initCharts()},500)},loadSampleData(){this.products=[{id:1,name:"iPhone 14 Pro",sku:"IPHONE14-PRO-128",category:"electronics",price:999.99,stock:45,status:"published",created:"2024-01-15",image:"/assets/images/product-placeholder.svg",description:"Latest iPhone with advanced camera system"},{id:2,name:"MacBook Air M2",sku:"MBA-M2-256",category:"electronics",price:1199.99,stock:23,status:"published",created:"2024-01-20",image:"/assets/images/product-placeholder.svg",description:"Lightweight laptop with M2 chip"},{id:3,name:"Cotton T-Shirt",sku:"TSHIRT-COT-M",category:"clothing",price:24.99,stock:156,status:"published",created:"2024-02-01",image:"/assets/images/product-placeholder.svg",description:"100% organic cotton t-shirt"},{id:4,name:"JavaScript Guide",sku:"BOOK-JS-2024",category:"books",price:39.99,stock:8,status:"published",created:"2024-02-10",image:"/assets/images/product-placeholder.svg",description:"Complete JavaScript programming guide"},{id:5,name:"Garden Tool Set",sku:"GARDEN-TOOLS-SET",category:"home",price:89.99,stock:0,status:"published",created:"2024-02-15",image:"/assets/images/product-placeholder.svg",description:"Professional garden tool kit"},{id:6,name:"Wireless Headphones",sku:"HEADPHONES-WL-BT",category:"electronics",price:149.99,stock:67,status:"published",created:"2024-02-20",image:"/assets/images/product-placeholder.svg",description:"Noise-cancelling wireless headphones"},{id:7,name:"Denim Jeans",sku:"JEANS-DENIM-32",category:"clothing",price:79.99,stock:34,status:"draft",created:"2024-02-25",image:"/assets/images/product-placeholder.svg",description:"Classic fit denim jeans"},{id:8,name:"Python Cookbook",sku:"BOOK-PY-COOK",category:"books",price:44.99,stock:15,status:"published",created:"2024-03-01",image:"/assets/images/product-placeholder.svg",description:"Advanced Python programming techniques"},{id:9,name:"Smart Home Hub",sku:"SMARTHUB-V2",category:"electronics",price:199.99,stock:12,status:"published",created:"2024-03-05",image:"/assets/images/product-placeholder.svg",description:"Central hub for smart home devices"},{id:10,name:"Kitchen Knife Set",sku:"KITCHEN-KNIVES-PRO",category:"home",price:129.99,stock:28,status:"pending",created:"2024-03-10",image:"/assets/images/product-placeholder.svg",description:"Professional chef knife collection"},{id:11,name:"Samsung Galaxy S24",sku:"GALAXY-S24-256",category:"electronics",price:899.99,stock:67,status:"published",created:"2024-03-12",image:"/assets/images/product-placeholder.svg",description:"Latest Samsung flagship smartphone"},{id:12,name:"Yoga Mat Premium",sku:"YOGA-MAT-PREM",category:"home",price:49.99,stock:156,status:"published",created:"2024-03-14",image:"/assets/images/product-placeholder.svg",description:"Non-slip premium yoga mat"},{id:13,name:"React Handbook",sku:"BOOK-REACT-2024",category:"books",price:54.99,stock:23,status:"published",created:"2024-03-16",image:"/assets/images/product-placeholder.svg",description:"Complete React development guide"},{id:14,name:"Winter Jacket",sku:"JACKET-WINTER-L",category:"clothing",price:189.99,stock:12,status:"published",created:"2024-03-18",image:"/assets/images/product-placeholder.svg",description:"Waterproof winter jacket"},{id:15,name:"Gaming Mouse RGB",sku:"MOUSE-GAMING-RGB",category:"electronics",price:79.99,stock:89,status:"published",created:"2024-03-20",image:"/assets/images/product-placeholder.svg",description:"High-precision gaming mouse"},{id:16,name:"Coffee Maker Deluxe",sku:"COFFEE-MAKER-DLX",category:"home",price:249.99,stock:34,status:"published",created:"2024-03-22",image:"/assets/images/product-placeholder.svg",description:"Programmable drip coffee maker"},{id:17,name:"Node.js Complete Guide",sku:"BOOK-NODEJS-COMP",category:"books",price:59.99,stock:18,status:"published",created:"2024-03-24",image:"/assets/images/product-placeholder.svg",description:"Master Node.js development"},{id:18,name:"Running Shoes",sku:"SHOES-RUN-42",category:"clothing",price:129.99,stock:0,status:"published",created:"2024-03-26",image:"/assets/images/product-placeholder.svg",description:"Lightweight running shoes"},{id:19,name:'Tablet Pro 12.9"',sku:"TABLET-PRO-129",category:"electronics",price:1099.99,stock:15,status:"published",created:"2024-03-28",image:"/assets/images/product-placeholder.svg",description:"Professional tablet with stylus"},{id:20,name:"Garden Planter Set",sku:"PLANTER-SET-3PC",category:"home",price:89.99,stock:45,status:"published",created:"2024-03-30",image:"/assets/images/product-placeholder.svg",description:"Set of 3 ceramic planters"},{id:21,name:"Docker Deep Dive",sku:"BOOK-DOCKER-DD",category:"books",price:49.99,stock:31,status:"published",created:"2024-04-01",image:"/assets/images/product-placeholder.svg",description:"Container technology mastery"},{id:22,name:"Casual Polo Shirt",sku:"POLO-CASUAL-M",category:"clothing",price:39.99,stock:78,status:"published",created:"2024-04-03",image:"/assets/images/product-placeholder.svg",description:"Premium cotton polo shirt"},{id:23,name:"Mechanical Keyboard",sku:"KEYBOARD-MECH-TKL",category:"electronics",price:159.99,stock:24,status:"published",created:"2024-04-05",image:"/assets/images/product-placeholder.svg",description:"Tenkeyless mechanical keyboard"},{id:24,name:"Desk Organizer",sku:"DESK-ORG-BAMBOO",category:"home",price:34.99,stock:62,status:"published",created:"2024-04-07",image:"/assets/images/product-placeholder.svg",description:"Bamboo desk organizer"},{id:25,name:"AI & Machine Learning",sku:"BOOK-AI-ML-2024",category:"books",price:79.99,stock:14,status:"published",created:"2024-04-09",image:"/assets/images/product-placeholder.svg",description:"Introduction to AI and ML"}]},calculateStats(){this.stats.total=this.products.length,this.stats.inStock=this.products.filter(t=>t.stock>20).length,this.stats.lowStock=this.products.filter(t=>t.stock>0&&t.stock<=20).length,this.stats.totalValue=this.products.reduce((t,s)=>t+s.price*s.stock,0);const e={};this.products.forEach(t=>{e[t.category]=(e[t.category]||0)+1}),this.categoryStats=Object.entries(e).map(([t,s])=>({name:t.charAt(0).toUpperCase()+t.slice(1),count:s,percentage:Math.round(s/this.products.length*100),color:this.getCategoryColor(t)}))},getCategoryColor(e){return{electronics:"#6366f1",clothing:"#8b5cf6",books:"#06b6d4",home:"#10b981"}[e]||"#6b7280"},filterProducts(){this.filteredProducts=this.products.filter(e=>{const t=!this.searchQuery||e.name.toLowerCase().includes(this.searchQuery.toLowerCase())||e.sku.toLowerCase().includes(this.searchQuery.toLowerCase()),s=!this.categoryFilter||e.category===this.categoryFilter,i=!this.stockFilter||this.stockFilter==="in-stock"&&e.stock>20||this.stockFilter==="low-stock"&&e.stock>0&&e.stock<=20||this.stockFilter==="out-of-stock"&&e.stock===0;return t&&s&&i}),this.sortProducts(),this.currentPage=1},sortProducts(){this.filteredProducts.sort((e,t)=>{let s=e[this.sortField],i=t[this.sortField];return this.sortField==="price"||this.sortField==="stock"?(s=parseFloat(s),i=parseFloat(i)):this.sortField==="created"?(s=new Date(s),i=new Date(i)):(s=s.toString().toLowerCase(),i=i.toString().toLowerCase()),this.sortDirection==="asc"?s<i?-1:s>i?1:0:s>i?-1:s<i?1:0})},sortBy(e){this.sortField===e?this.sortDirection=this.sortDirection==="asc"?"desc":"asc":(this.sortField=e,this.sortDirection="asc"),this.filterProducts()},toggleAll(e){e?this.selectedProducts=this.paginatedProducts.map(t=>t.id):this.selectedProducts=[]},bulkAction(e){if(this.selectedProducts.length===0)return;const t=this.products.filter(s=>this.selectedProducts.includes(s.id));switch(e){case"publish":t.forEach(s=>{s.status="published"}),this.showNotification("Products published successfully!","success");break;case"unpublish":t.forEach(s=>{s.status="draft"}),this.showNotification("Products unpublished successfully!","info");break;case"delete":confirm(`Are you sure you want to delete ${this.selectedProducts.length} product(s)?`)&&(this.products=this.products.filter(s=>!this.selectedProducts.includes(s.id)),this.filterProducts(),this.calculateStats(),this.showNotification("Products deleted successfully!","success"));break}this.selectedProducts=[]},editProduct(e){console.log("Edit product:",e),this.showNotification("Edit functionality would open here","info")},viewProduct(e){console.log("View product:",e),this.showNotification("Product details would open here","info")},duplicateProduct(e){const t={...e,id:Math.max(...this.products.map(s=>s.id))+1,name:e.name+" (Copy)",sku:e.sku+"-COPY",status:"draft",created:new Date().toISOString().split("T")[0]};this.products.unshift(t),this.filterProducts(),this.calculateStats(),this.showNotification("Product duplicated successfully!","success")},deleteProduct(e){confirm(`Are you sure you want to delete "${e.name}"?`)&&(this.products=this.products.filter(t=>t.id!==e.id),this.filterProducts(),this.calculateStats(),this.showNotification("Product deleted successfully!","success"))},exportProducts(){const e=`data:text/csv;charset=utf-8,Name,SKU,Category,Price,Stock,Status,Created
`+this.filteredProducts.map(i=>`"${i.name}","${i.sku}","${i.category}","${i.price}","${i.stock}","${i.status}","${i.created}"`).join(`
`),t=encodeURI(e),s=document.createElement("a");s.setAttribute("href",t),s.setAttribute("download","products.csv"),document.body.appendChild(s),s.click(),document.body.removeChild(s),this.showNotification("Products exported successfully!","success")},showNotification(e,t="info"){typeof Swal<"u"?Swal.fire({title:e,icon:t==="success"?"success":t==="error"?"error":"info",toast:!0,position:"top-end",showConfirmButton:!1,timer:3e3}):alert(e)},initCharts(){this.chartsInitialized||(this.initSalesChart(),this.initCategoryChart(),this.chartsInitialized=!0)},initSalesChart(){const e=document.getElementById("salesChart");if(!e){console.warn("Sales chart element not found");return}e.innerHTML="";try{const t={series:[{name:"Sales",data:[65,78,85,92,88,95,102]}],chart:{type:"area",height:300,toolbar:{show:!1}},colors:["#6366f1"],fill:{type:"gradient",gradient:{shadeIntensity:1,opacityFrom:.7,opacityTo:.3}},stroke:{curve:"smooth",width:2},xaxis:{categories:["Mon","Tue","Wed","Thu","Fri","Sat","Sun"]},yaxis:{title:{text:"Sales ($1000s)"}},tooltip:{y:{formatter:function(i){return"$"+i+"k"}}}};new ApexCharts(e,t).render()}catch(t){console.error("Error rendering sales chart:",t)}},initCategoryChart(){const e=document.getElementById("categoryChart");if(!e){console.warn("Category chart element not found");return}e.innerHTML="";try{const t={series:this.categoryStats.map(i=>i.count),chart:{type:"donut",height:200},labels:this.categoryStats.map(i=>i.name),colors:this.categoryStats.map(i=>i.color),plotOptions:{pie:{donut:{size:"70%"}}},legend:{show:!1},tooltip:{y:{formatter:function(i){return i+" products"}}}};new ApexCharts(e,t).render()}catch(t){console.error("Error rendering category chart:",t)}},get paginatedProducts(){const e=(this.currentPage-1)*this.itemsPerPage,t=e+this.itemsPerPage;return this.filteredProducts.slice(e,t)},get totalPages(){return Math.ceil(this.filteredProducts.length/this.itemsPerPage)},get visiblePages(){if(this.totalPages<=1)return[1];const e=[];if(e.push(1),this.totalPages<=7)for(let t=2;t<=this.totalPages;t++)e.push(t);else if(this.currentPage<=4){for(let t=2;t<=5;t++)e.push(t);e.push("..."),e.push(this.totalPages)}else if(this.currentPage>=this.totalPages-3){e.push("...");for(let t=this.totalPages-4;t<=this.totalPages;t++)e.push(t)}else{e.push("...");for(let t=this.currentPage-1;t<=this.currentPage+1;t++)e.push(t);e.push("..."),e.push(this.totalPages)}return e},goToPage(e){e>=1&&e<=this.totalPages&&(this.currentPage=e)}})),o.data("productForm",()=>({form:{name:"",sku:"",category:"",price:"",stock:"",description:"",status:"draft"},saveProduct(){if(!this.form.name||!this.form.sku||!this.form.category||!this.form.price||!this.form.stock||!this.form.status){alert("Please fill in all required fields");return}console.log("Saving product:",this.form),typeof Swal<"u"?Swal.fire({title:"Product Saved!",text:"The product has been saved successfully",icon:"success",confirmButtonText:"OK"}):alert("Product saved successfully!"),this.form={name:"",sku:"",category:"",price:"",stock:"",description:"",status:"draft"}}})),o.data("searchComponent",()=>({query:"",search(){console.log("Searching for:",this.query)}})),o.data("themeSwitch",()=>({currentTheme:"light",init(){this.currentTheme=localStorage.getItem("theme")||"light",document.documentElement.setAttribute("data-bs-theme",this.currentTheme)},toggle(){this.currentTheme=this.currentTheme==="light"?"dark":"light",document.documentElement.setAttribute("data-bs-theme",this.currentTheme),localStorage.setItem("theme",this.currentTheme)}}))});
