import{m as a}from"./vendor-ui-CflGdlft.js";document.addEventListener("alpine:init",()=>{a.data("securityComponent",()=>({activeSection:"account",loading:!1,sidebarVisible:!1,securityScore:85,lastSecurityAudit:"2024-01-15",activeThreats:2,blockedAttempts:47,auth:{twoFactorEnabled:!0,biometricEnabled:!1,sessionTimeout:30,maxSessions:5,requirePasswordChange:90,passwordMinLength:12,requireSpecialChars:!0,requireNumbers:!0,requireUppercase:!0},activeSessions:[{id:1,device:"Desktop - Chrome",deviceIcon:"bi-laptop",location:"New York, USA",ip:"192.168.1.100",lastActive:"2 minutes ago",current:!0,isCurrent:!0},{id:2,device:"Mobile - Safari",deviceIcon:"bi-phone",location:"New York, USA",ip:"192.168.1.101",lastActive:"1 hour ago",current:!1,isCurrent:!1},{id:3,device:"Tablet - Chrome",deviceIcon:"bi-tablet",location:"Chicago, USA",ip:"203.0.113.42",lastActive:"2 days ago",current:!1,isCurrent:!1}],permissions:{adminAccess:!1,userManagement:!0,systemSettings:!1,dataExport:!0,apiAccess:!0},securityData:{recoveryEmail:"john.doe@example.com",lockoutProtection:!0,twoFactor:{app:!0,sms:!1},privacy:{profileVisibility:"friends",showActivity:!0,dataCollection:!1}},sections:[{id:"account",name:"Account Security",icon:"bi-shield-check"},{id:"twofactor",name:"Two-Factor Auth",icon:"bi-key"},{id:"sessions",name:"Active Sessions",icon:"bi-laptop"},{id:"privacy",name:"Privacy Settings",icon:"bi-eye-slash"},{id:"activity",name:"Security Activity",icon:"bi-activity"}],securityActivity:[{id:1,type:"login_success",message:"Successful login from new device",timestamp:"2024-01-20 14:30:00",severity:"info",icon:"bi-check-circle",details:"Chrome on Windows from New York, USA"},{id:2,type:"password_change",message:"Password changed successfully",timestamp:"2024-01-19 09:15:00",severity:"success",icon:"bi-shield-lock",details:"Password updated via security settings"},{id:3,type:"failed_login",message:"Multiple failed login attempts detected",timestamp:"2024-01-18 16:45:00",severity:"warning",icon:"bi-exclamation-triangle",details:"5 failed attempts from IP 203.0.113.99"},{id:4,type:"account_locked",message:"Account temporarily locked due to suspicious activity",timestamp:"2024-01-17 11:20:00",severity:"danger",icon:"bi-lock",details:"Auto-locked after 10 failed login attempts"}],securityEvents:[{id:1,type:"login_success",message:"Successful login from new device",timestamp:"2024-01-20 14:30:00",severity:"info",details:"Chrome on Windows from New York, USA"},{id:2,type:"password_change",message:"Password changed successfully",timestamp:"2024-01-19 09:15:00",severity:"success",details:"Password updated via security settings"},{id:3,type:"failed_login",message:"Multiple failed login attempts detected",timestamp:"2024-01-18 16:45:00",severity:"warning",details:"5 failed attempts from IP 203.0.113.99"},{id:4,type:"account_locked",message:"Account temporarily locked due to suspicious activity",timestamp:"2024-01-17 11:20:00",severity:"danger",details:"Auto-locked after 10 failed login attempts"}],notifications:{loginAlerts:!0,securityUpdates:!0,suspiciousActivity:!0,weeklyReports:!1},backupCodes:["ABC123-DEF456","GHI789-JKL012","MNO345-PQR678","STU901-VWX234","YZA567-BCD890"],init(){this.loadSecuritySettings()},setActiveSection(t){this.activeSection=t},get securityScoreColor(){return this.securityScore>=90?"success":this.securityScore>=70?"warning":"danger"},get securityScoreText(){return this.securityScore>=90?"Excellent":this.securityScore>=70?"Good":this.securityScore>=50?"Fair":"Poor"},changePassword(){this.showNotification("Password change dialog would open here","info")},updateRecoveryEmail(){this.showNotification("Recovery email update dialog would open here","info")},setupAuthenticatorApp(){this.securityData.twoFactor.app?this.showNotification("Authenticator app management would open here","info"):(this.securityData.twoFactor.app=!0,this.showNotification("Authenticator app setup completed","success"),this.recalculateSecurityScore())},setupSMSVerification(){this.securityData.twoFactor.sms?this.showNotification("SMS verification management would open here","info"):(this.securityData.twoFactor.sms=!0,this.showNotification("SMS verification setup completed","success"),this.recalculateSecurityScore())},generateBackupCodes(){this.regenerateBackupCodes()},viewSecurityLog(){this.setActiveSection("activity"),this.showNotification("Switched to security activity log","info")},emergencyLockdown(){confirm("Are you sure you want to initiate emergency lockdown? This will log out all sessions and require password reset.")&&(this.activeSessions=this.activeSessions.filter(t=>t.current),this.showNotification("Emergency lockdown initiated. All sessions terminated.","warning"))},loadMoreActivity(){this.showNotification("Loading more security activity...","info")},toggleTwoFactor(){this.auth.twoFactorEnabled?confirm("Are you sure you want to disable two-factor authentication? This will make your account less secure.")&&(this.auth.twoFactorEnabled=!1,this.showNotification("Two-factor authentication disabled","warning"),this.recalculateSecurityScore()):this.showTwoFactorSetup()},showTwoFactorSetup(){confirm("Set up two-factor authentication using your mobile device?")&&(this.auth.twoFactorEnabled=!0,this.showNotification("Two-factor authentication enabled","success"),this.recalculateSecurityScore())},toggleBiometric(){if("credentials"in navigator){this.auth.biometricEnabled=!this.auth.biometricEnabled;const t=this.auth.biometricEnabled?"enabled":"disabled";this.showNotification(`Biometric authentication ${t}`,"success"),this.recalculateSecurityScore()}else this.showNotification("Biometric authentication not supported on this device","warning")},terminateSession(t){confirm("Are you sure you want to terminate this session?")&&(this.activeSessions=this.activeSessions.filter(e=>e.id!==t),this.showNotification("Session terminated successfully","success"))},terminateAllSessions(){confirm("Are you sure you want to terminate all other sessions? You will need to log in again on those devices.")&&(this.activeSessions=this.activeSessions.filter(t=>t.current),this.showNotification("All other sessions terminated","success"))},generatePassword(){const t=this.auth.passwordMinLength,e="abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@#$%^&*";let i="";for(let s=0;s<t;s++)i+=e.charAt(Math.floor(Math.random()*e.length));navigator.clipboard.writeText(i).then(()=>{this.showNotification("Strong password generated and copied to clipboard","success")}).catch(()=>{this.showNotification(`Generated password: ${i}`,"info")})},regenerateBackupCodes(){confirm("Are you sure you want to regenerate backup codes? This will invalidate all existing codes.")&&(this.backupCodes=this.generateNewBackupCodes(),this.showNotification("Backup codes regenerated successfully","success"))},generateNewBackupCodes(){const t=[];for(let e=0;e<5;e++){const i=Math.random().toString(36).substring(2,8).toUpperCase()+"-"+Math.random().toString(36).substring(2,8).toUpperCase();t.push(i)}return t},downloadBackupCodes(){const t=this.backupCodes.join("\\n"),e=new Blob([t],{type:"text/plain"}),i=URL.createObjectURL(e),s=document.createElement("a");s.href=i,s.download="backup-codes.txt",s.click(),URL.revokeObjectURL(i),this.showNotification("Backup codes downloaded","success")},runSecurityAudit(){this.loading=!0,this.showNotification("Running security audit...","info"),setTimeout(()=>{this.loading=!1,this.lastSecurityAudit=new Date().toISOString().split("T")[0],this.securityScore=Math.floor(Math.random()*20)+80,this.showNotification("Security audit completed","success")},3e3)},recalculateSecurityScore(){let t=60;this.auth.twoFactorEnabled&&(t+=20),this.auth.biometricEnabled&&(t+=10),this.auth.passwordMinLength>=12&&(t+=10),this.auth.requireSpecialChars&&this.auth.requireNumbers&&(t+=5),this.securityScore=Math.min(t,100)},exportSecurityLog(){const t={securityEvents:this.securityEvents,activeSessions:this.activeSessions,securityScore:this.securityScore,exportDate:new Date().toISOString()},e=JSON.stringify(t,null,2),i=new Blob([e],{type:"application/json"}),s=URL.createObjectURL(i),o=document.createElement("a");o.href=s,o.download="security-log.json",o.click(),URL.revokeObjectURL(s),this.showNotification("Security log exported","success")},loadSecuritySettings(){const t=localStorage.getItem("securitySettings");if(t)try{const e=JSON.parse(t);this.auth={...this.auth,...e.auth},this.notifications={...this.notifications,...e.notifications},this.permissions={...this.permissions,...e.permissions}}catch(e){console.warn("Failed to load security settings:",e)}this.recalculateSecurityScore()},saveSecuritySettings(){const t={auth:this.auth,notifications:this.notifications,permissions:this.permissions};try{localStorage.setItem("securitySettings",JSON.stringify(t)),this.showNotification("Security settings saved","success")}catch{this.showNotification("Failed to save settings","error")}},showNotification(t,e="info"){console.log(`[${e.toUpperCase()}] ${t}`),document.dispatchEvent(new CustomEvent("showNotification",{detail:{message:t,type:e}}))}})),a.data("searchComponent",()=>({query:"",results:[],search(){this.query.trim()&&(console.log("Searching for:",this.query),this.results=[])}})),a.data("themeSwitch",()=>({currentTheme:"light",init(){this.currentTheme=document.documentElement.getAttribute("data-bs-theme")||localStorage.getItem("theme")||"light"},toggle(){this.currentTheme=this.currentTheme==="light"?"dark":"light",document.documentElement.setAttribute("data-bs-theme",this.currentTheme),localStorage.setItem("theme",this.currentTheme)}}))});
